/*

    This code is part of Truss Solver which is free software.
    See the file COPYING for more details.

    Copyright (C) 1997  T. W. Shield, shield@aem.umn.edu

*/

/**********************************************************************

	--- Dlgedit generated file ---

	File: Add_bc.cpp
	Last generated: Sat Sep 13 13:16:57 1997

 *********************************************************************/

#include <qapp.h>
#include <qstring.h>
#include "Add_bc.h"
#include "../global.h"
#include "../yesnoinfo.h"
#include "../icons/addbc_icon.xpm"
#include <stdio.h>

#define Inherited Add_bcData

Add_bc::Add_bc
(
	int type,
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	setCaption( "Add BC" );
	
	setFixedSize(width(),height());
	
	if(truss->type() == FRAME)
	{
		direction_combo->insertItem("Rotation/Moment");
		direction_combo->insertItem("Distributed");
	}
	
	if(type == 1) // elemental, that is, distributed only
	{
		direction_combo->setCurrentItem(DISTRIBUTED);
		direction_combo->setEnabled(FALSE);
		type_combo->setCurrentItem(0); // force
		type_combo->setEnabled(FALSE);
		type_label->setText("Element");
	}
	
	int n,i;
	char temp[10];
	
	if(type == 0)
		n = truss->nodes();
	else
		n = truss->elems();
	
	if(n == 0)
		accept();
		
	item_list->setAutoUpdate(FALSE);
	for(i=1;i<=n;i++)
	{
		sprintf(temp,"%i",i);
		item_list->insertItem(temp);
	}
	
	item_list->setAutoUpdate(TRUE);
	item_list->repaint();
	
/*
	set the window icon and text and window caption
*/


    QPixmap win_icon(addbc_icon);
    
    setIcon(win_icon);

    const char title[]="Add BC";

    setCaption(title);
    setIconText(title);
	
}


Add_bc::~Add_bc()
{
}

void Add_bc::accept_bc()
{
	int n,d,ret,type;
	float v;
	QString qs;
	bool chk;
	
	n=item_list->currentItem()+1;
	
	if(n == 0)
		return;
		
	d = direction_combo->currentItem()+1;
	
	qs=value_text->text();
	
	v=qs.toFloat(&chk);
	
	if(chk == FALSE)
	{
		qApp->beep();
		return;
	}
	
	type = type_combo->currentItem();
	
	if(type == 1 && d == DISTRIBUTED) // displacment and distributed make no sense
	{
		InfoDialog info(this,"Don't know what a distributed displacement is");
		info.exec();
		return;
	}
	
	if(type == 0) // force
		ret=truss->add_load(n,d,v);
	else
		ret=truss->add_restraint(n,d,v);
		
	if(ret == BAD)
	{
		InfoDialog info(this,"Addition of BC failed");
		info.exec();
		return;
	}
	
	if(ret == DUP)
	{
		InfoDialog info(this,"Error: Duplicate BC");
		info.exec();
		return;
	}			

	accept(); // done with this dialog
}
