/*

    This code is part of Truss Solver which is free software.
    See the file COPYING for more details.

    Copyright (C) 1997  T. W. Shield, shield@aem.umn.edu

*/

/**********************************************************************

	--- Dlgedit generated file ---

	File: Edit_Bcs.cpp
	Last generated: Sat Sep 13 12:23:43 1997

 *********************************************************************/

#include "Edit_Bcs.h"
#include "../global.h"
#include "Add_bc.h"
#include "../icons/bc_icon.xpm"
#include <stdio.h>

#define Inherited Edit_BcsData

Edit_Bcs::Edit_Bcs
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	setCaption( "Edit BC's" );
	
	setFixedSize(width(),height());
	
	init();
	
/*
	set the window icon and text and window caption
*/


    QPixmap win_icon(bc_icon);
    
    setIcon(win_icon);

    const char title[]="Edit BCs";

    setCaption(title);
    setIconText(title);
	
}

void Edit_Bcs::init()
{	
	int nloads,nrestraints,i,d,n;
	float v;
	char item[100];
	
	if(truss->type() == FRAME)
	{
		type_label->show();
		type_combo->show();
	}
	else
	{
		type_label->hide();
		type_combo->setCurrentItem(0); // nodal
		type_combo->hide();
	}
	
	nloads=truss->loads();
	nrestraints = truss->restraints();
	
	bcs_list->clear();
	
	if(nloads > 0)
	{
		for(i=1;i<=nloads;i++)
		{
			n=truss->load_node(i);
			d=truss->load_dir(i);
			v=truss->load_val(i);
			if(d == X_DIRECTION)
				sprintf(item,"Node %i: x direction force of %g",n,v);
			if(d == Y_DIRECTION)
				sprintf(item,"Node %i: y direction force of %g",n,v);
			if(d == MOMENT)
				sprintf(item,"Node %i: moment of %g",n,v);
			if(d == DISTRIBUTED)
				sprintf(item,"Element %i: distributed force of %g",n,v);
			
			bcs_list->inSort(item);
		}
	}
	
	if(nrestraints > 0)
	{
		for(i=1;i<=nrestraints;i++)
		{
			n=truss->restraint_node(i);
			d=truss->restraint_dir(i);
			v=truss->restraint_val(i);
			if(d == X_DIRECTION)
				sprintf(item,"Node %i: x direction displacement of %g",n,v);
			if(d == Y_DIRECTION)
				sprintf(item,"Node %i: y direction displacement of %g",n,v);
			if(d == ROTATION)
				sprintf(item,"Node %i: rotation of %g",n,v);
			
			bcs_list->inSort(item);
		}
	}
			
	
	
}


Edit_Bcs::~Edit_Bcs()
{
}

void Edit_Bcs::add_bc()
{
	int type;
	
	type=type_combo->currentItem();  // nodal == 0
	
	Add_bc *addbc=new Add_bc(type,this);
	
	if(addbc->exec())	
		init(); // the lazy way
		
	delete addbc;
	
	main_win->repaint(); // update node colors

}

#define LOAD 0
#define RESTRAINT 1

void Edit_Bcs::delete_bc()
{
	char temp[100],*t;
	int d,type,n;

	if(bcs_list->currentItem() == -1)
		return;
	
	strcpy(temp,bcs_list->text(bcs_list->currentItem()));
	
	d=-1;
	type=-1;
	
	if(strstr(temp,"x direction") != NULL)
		d = X_DIRECTION;
			
	if(strstr(temp,"y direction") != NULL)
		d = Y_DIRECTION;	
		
	if(strstr(temp,"moment") != NULL)
	{
		d = MOMENT;
		type = LOAD;
	}	
	if(strstr(temp,"rotation") != NULL)
	{
		d = ROTATION;
		type = RESTRAINT;
	}	
		
	if(strstr(temp,"distributed") != NULL)
		d = DISTRIBUTED;
			
	if(strstr(temp,"force") != NULL)
		type = LOAD;
		
	if(strstr(temp,"displacement") != NULL)
		type = RESTRAINT;
		
	if( d == -1 || type == -1)
		return;
		
	t=strchr(temp,':');
	if(t != NULL)
		*t='\0';
	else
		return;
	
	if(d != DISTRIBUTED)
		n = atoi(temp + 4);
	else
		n = atoi(temp + 7);

	if( n == 0) 
		return;
		
	if(type == LOAD)
		truss->delete_load(n,d);
	else
		truss->delete_restraint(n,d);
		
	bcs_list->removeItem(bcs_list->currentItem());
	
	main_win->repaint(); // for node colors change
		
}

void Edit_Bcs::reinit()
{
	init();
}
