/*

    This code is part of Truss Solver which is free software.
    See the file COPYING for more details.

    Copyright (C) 1997  T. W. Shield, shield@aem.umn.edu

*/

/**********************************************************************

	--- Dlgedit generated file ---

	File: ElemEdit.cpp
	Last generated: Sun Sep 7 18:50:07 1997

 *********************************************************************/

#include "ElemEdit.h"
#include "../global.h"
#include "../yesnoinfo.h"
#include "../icons/elem_icon.xpm"
#include <stdio.h>

#define Inherited ElemEditData

ElemEdit::ElemEdit
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	setCaption( "Element Edit" );
	
	setFixedSize(width(),height());
	
	init();
	
	connect(main_win,SIGNAL(elem_clicked(int)),SLOT(set_elem_click(int)));
/*
	set the window icon and text and window caption
*/


    QPixmap win_icon(elem_icon);
    
    setIcon(win_icon);

    const char title[]="Edit Elements";

    setCaption(title);
    setIconText(title);
	
}

void ElemEdit::init()
{
	int n_elems,i;
	char temp[20];
	
	n_elems = truss->elems();
	
	elem_number_list->clear();
	
	if(n_elems > 0)
	{
		elem_number_list->setAutoUpdate(FALSE);
	
		for(i=1;i<=n_elems;i++)
		{
			sprintf(temp,"%i",i);
			elem_number_list->insertItem(temp);
		}
		elem_number_list->setAutoUpdate(TRUE);
	
		element = 1;
			
		elem_number_list->repaint();
	}
	else
		element = 0;
						
	init_node_lists();
	
	init_mpset_list();
	
	if(n_elems > 0) // this causes a sync_lists to be done
		elem_number_list->setCurrentItem(element-1);
		
	update_next = FALSE;
			
}

void ElemEdit::init_mpset_list()
{
	int i,n_mpsets;
	char temp[10];
	
	n_mpsets = truss->mpsets();
	
	mpset_list->clear();
	
	if(n_mpsets > 0)
	{
	     for(i=1;i<=n_mpsets;i++)
	     {
		sprintf(temp,"%i",i);
		mpset_list->insertItem(temp);
	     }
	}
	
	mpset_list->repaint();
}

void ElemEdit::init_node_lists()
{
	int i,n_nodes;
	char temp[10];
	
	n_nodes = truss->nodes();

	node1_list->clear();
	node2_list->clear();
	
	if(n_nodes > 0)
	{
	    node1_list->setAutoUpdate(FALSE);
	    node2_list->setAutoUpdate(FALSE);
	
	    for(i=1;i<=n_nodes;i++)
	    {
		sprintf(temp,"%i",i);
		node1_list->insertItem(temp);
		node2_list->insertItem(temp);
	    }
	    node1_list->setAutoUpdate(TRUE);
	    node2_list->setAutoUpdate(TRUE);
	}

	node1_list->repaint();
	node2_list->repaint();
}

ElemEdit::~ElemEdit()
{
}


void ElemEdit::sync_lists()
{
	int n1,n2,mpset;
	
	if(element > 0 && element <= truss->elems() )
	{
		n1 = truss->node1(element);
		n2 = truss->node2(element);
		mpset = truss->mpset(element);

		if(n1 > 0)
		{
			node1_list->setCurrentItem(n1-1);
			node1_list->centerCurrentItem();
		}
		
		if(n2 > 0)
		{
			node2_list->setCurrentItem(n2-1);
			node2_list->centerCurrentItem();
		}
	
		if(mpset > 0)
		{
			mpset_list->setCurrentItem(mpset-1);
			mpset_list->centerCurrentItem();
		}
	}
}

void ElemEdit::set_elem_number(int i)
{
	element = i+1;
	sync_lists();
}

void ElemEdit::update_element()
{
	int n1,n2,mpset,ret;
	
	n1 = node1_list->currentItem()+1;
	n2 = node2_list->currentItem()+1;
	mpset = mpset_list->currentItem()+1;
	
	if(n1 == 0 || n2 == 0 || mpset == 0)
	{
		InfoDialog info(this,"Must select both nodes and MP set");
		info.exec();
		return;
	}
	
	if(n1 == n2) // from add element
	{
		InfoDialog info(this,"Nodes must be different");
		info.exec();
		return;
	}
	
	if(element > truss->elems())
	{
		ret=truss->add_elem(n1,n2,mpset);
		if(ret == OK)
		{
			update_next = FALSE;
			emit elems_changed();
		}
	}
	else
		ret=truss->update_elem(element,n1,n2,mpset);
	
	if( ret == BAD )
	{
		InfoDialog info(this,"Update element failed");
		info.exec();
		return;
	}
	if( ret == DUP )
	{
		InfoDialog info(this,"Update failed: Duplicate Element");
		info.exec();
		return;
	}
	
	main_win->repaint();
		

}

void ElemEdit::add_element()
{
	int n;
	char temp[20];
	
	if( update_next )
	{
		InfoDialog info(this,"Update previously added node first");
		info.exec();
		return;
	}
		
	
	n=truss->nodes();
	if(n < 2)
	{
		InfoDialog info(this,"Must have at least 2 nodes");
		info.exec();
		return;
	}
	
	n=truss->mpsets();
	if(n < 1)
	{
		InfoDialog info(this,"Must have at least 1 MP set");
		info.exec();
		return;
	}
	
	n = truss->elems();
	sprintf(temp,"%i",n+1);

	
	elem_number_list->insertItem(temp);
	elem_number_list->setCurrentItem(n);
	elem_number_list->centerCurrentItem();
	
	element = n+1;// redundant due to setCurrentItem doing a set_elem_number

	update_next = TRUE;	
}

void ElemEdit::delete_element()
{
	int n;
	
	if(element <= truss->elems())
	{
		if(truss->elem_in_bc(element) == 0)
		{
	
			truss->delete_elem(element);
	
			n = elem_number_list->count();// may have one more item than elems from add
			if(element >= n)
				element = n-1;
			elem_number_list->removeItem(n-1);
				
			emit elems_changed();
		}
		else
		{
			InfoDialog info(this,"Cannot delete: Element has distributed load");
			info.exec();
			return;
		}
		
	}
	else // for added but not updated element
	{
		elem_number_list->removeItem(element-1);
		element--;
		update_next = FALSE;
	}
		
		
	sync_lists();
	
	main_win->repaint();

}

void ElemEdit::set_elem_click(int i) //slot for main_win click
{
	if(isVisible())
	{

		elem_number_list->setCurrentItem(i-1); // syncs the lists via highlighted signal
		elem_number_list->centerCurrentItem();
		element = i; // also redundant

	}

}

void ElemEdit::refresh_nodes() // slot if nodes get changed
{
	if(isVisible())
	{
		init_node_lists();
	
		sync_lists();
	}
}

void ElemEdit::refresh_mpsets() // slot if mpsets get changed
{
	if(isVisible())
	{
		init_mpset_list();
	
		sync_lists();	
	}
}
