/*

    This code is part of Truss Solver which is free software.
    See the file COPYING for more details.

    Copyright (C) 1997  T. W. Shield, shield@aem.umn.edu

*/
#include "fpoint.h"

FPoint::FPoint()
{
	xpos=0.;
	ypos=0.;
}

FPoint::FPoint(float x,float y)
{
	xpos=x;
	ypos=y;
}

void FPoint::setX(float x)
{
	xpos=x;
}

void FPoint::setY(float y)
{
	ypos=y;
}

float FPoint::x() const
{
	return(xpos);
}

float FPoint::y() const
{
	return(ypos);
}

float FPoint::dist(FPoint p)
{
	float dx,dy;
	
	dx=xpos-p.x();
	dy=ypos-p.y();
	
	return (sqrt(dx*dx+dy*dy));
}

void FPoint::print(ostream *os)
{
	*os << "("<<xpos<<","<<ypos<<")";
}

ostream &operator<<(ostream &os, FPoint &p)
{
	p.print(&os);
	return os;
}

FPoint operator*(const float f,const FPoint p)
{
FPoint ans;

	ans.setX(f*p.x());
	ans.setY(f*p.y());
	
	return(ans);
}

FPoint operator+(const FPoint p1,const FPoint p2)
{
FPoint ans;

	ans.setX(p1.x()+p2.x());
	ans.setY(p1.y()+p2.y());
	
	return(ans);
}

