/*

    Truss Solver
    Copyright (C) 1997  T. W. Shield, shield@aem.umn.edu

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

        Truss Solver requires the Qt library, which is copyright
        Troll Tech AS.  Freely distributable programs may generally
        use Qt for free, see README.QT for details.

*/
#define MAIN
#include "global.h"
#include "yesnoinfo.h"
#include <qapp.h>
#include <qfont.h>
#include <qpoint.h>
#include <qrect.h>
#include <iostream.h>
#include <math.h>
#include <stdio.h>

 


/**********************************************************

	non mywin object stuff below this 
	
***************************************************/	

int qpdist(QPoint p1,QPoint p2)
{
	int dx,dy;
	
	dx=abs(p1.x()-p2.x());
	dy=abs(p1.y()-p2.y());

	if( dx > dy )
		return(dx);
	else	
		return(dy);
}



main(int argc, char **argv)
{

	QApplication a( argc, argv );

/* set up the model */
	truss = new truss_model;

/* set up the main window */
	main_win = new mywin;
	
/* set up node edit window */
	node_win = new NodeEdit;
	
/* set up element edit window */
	elem_win = new ElemEdit;

/* set up mpset edit window */
	mpset_win = new MpsetEdit;
	
/* set up bcs edit window */
	bcs_win = new Edit_Bcs;

#ifdef SGI
    cout.setf(ios::unitbuf,ios::unitbuf);
#endif
        
    main_win->set_limits();

    main_win->resize( 500, 400 );

    a.setMainWidget( main_win );
    
    QObject::connect(node_win,SIGNAL(nodes_changed()),elem_win,SLOT(refresh_nodes()));
    QObject::connect(mpset_win,SIGNAL(mpsets_changed()),elem_win,SLOT(refresh_mpsets()));
    QObject::connect(node_win,SIGNAL(nodes_changed()),bcs_win,SLOT(reinit()));
    QObject::connect(elem_win,SIGNAL(elems_changed()),bcs_win,SLOT(reinit()));
    
        
    QObject::connect(main_win, SIGNAL(quit()),&a, SLOT(quit()) );

    main_win->show();
    return a.exec();
}
