#include <iostream.h>
#include "vector.h"

#ifndef MATRIX
#define MATRIX

/*

	matrix class 
	
	all interface functions take indices in the range
	
	1 to size

	only does square matrices

*/

// used for zero pivots in solve:
#define ZERO_TOL 1.e-6

class Matrix
{

public:
	Matrix(int size); //size is the max dimension to allow for
	Matrix(Matrix &); // copy constructor
	Matrix(Matrix *); // copy constructor
	
	~Matrix();

	float array(int,int); // returns element (i,j)
	float array(int,int) const;
	
	void array(int,int,float); // sets element (i,j)
	void array_add(int,int,float); // adds float to (i,j) current value
	
	void assem(Matrix, int ,int, int); // assembles (inserts) Matrix
		// at location for nodes i,j with ndof per node n
		
	void symm(); // symmeterizes the matrix from a half filled one
	
	float rhs(int); // return element (i,ndim+1)
	void rhs(int,float); // sets element (i,ndim+1)
	void rhs_add(int,float); // adds float to current rhs value
	void rhs(Vector *); // sets the ndim+1 column to the vector
	int rhs_def(); // = 1 if it is
	
	void triv_row(int,float); // sets array(i,i)=1 and rhs(i)=float
			// all other set zero

	Vector solve(int *ret=0); // solves ax=b, returns x
		//ret codes: 0 = OK
		//           1 = zero pivot encountered
	
	int size(); // return the size dim_size
	int size() const;
	
	void print(ostream *);
	
	void operator=(Matrix ); // assignment operator
	
	void enlarge(int);// enlarges by inc row and cols
			// tosses the rhs


private:

	int ndim; // max dimension of the matrix

	float *data; // pointer to the data
	
	int have_rhs; // =1 if rhs data set

	void init(int);
	
};

ostream &operator<<(ostream &os, Matrix *m);
ostream &operator<<(ostream &os, Matrix &m);

Vector operator*(const Matrix &,const Vector &); // matrix multiply


#endif // MATRIX
