/*

    This code is part of Truss Solver which is free software.
    See the file COPYING for more details.

    Copyright (C) 1997  T. W. Shield, shield@aem.umn.edu

*/

/**********************************************************************

	--- Dlgedit generated file ---

	File: BeamProp.cpp
	Last generated: Sun Sep 14 18:15:14 1997

 *********************************************************************/

#include <qapp.h>
#include <qstring.h>
#include "BeamProp.h"
#include "../global.h"
#include <stdio.h>

#define Inherited BeamPropData

BeamProp::BeamProp
(
	int set,
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	setCaption( "Beam Properties" );
	
	setFixedSize(width(),height());
	
	mpset=set;
	
	float I,Q,SR1,SR2,NA_width;
	char temp[20];
	
	I=truss->I(mpset);
	Q=truss->Q(mpset);
	SR1=truss->SR1(mpset);
	SR2=truss->SR2(mpset);
	NA_width=truss->NA_width(mpset);
	
	sprintf(temp,"%g",I);
	I_text->setText(temp);
	sprintf(temp,"%g",Q);
	Q_text->setText(temp);
	sprintf(temp,"%g",SR1);
	SR1_text->setText(temp);
	sprintf(temp,"%g",SR2);
	SR2_text->setText(temp);
	sprintf(temp,"%g",NA_width);
	NA_width_text->setText(temp);
	
}


BeamProp::~BeamProp()
{
}

void BeamProp::accept_properties()
{
	
	float I,Q,SR1,SR2,NA_width;
	QString qs;
	bool chk;
	
	qs=I_text->text();
	
	I=qs.toFloat(&chk);
	
	if(chk == FALSE)
	{
		qApp->beep();		
		return;
	}
	
	qs=Q_text->text();
	
	Q=qs.toFloat(&chk);
	
	if(chk == FALSE)
	{
		qApp->beep();		
		return;
	}
	
	qs=SR1_text->text();
	
	SR1=qs.toFloat(&chk);
	
	if(chk == FALSE)
	{
		qApp->beep();		
		return;
	}
	
	
	qs=SR2_text->text();
	
	SR2=qs.toFloat(&chk);
	
	if(chk == FALSE)
	{
		qApp->beep();		
		return;
	}
	
	qs=NA_width_text->text();
	
	NA_width=qs.toFloat(&chk);
	
	if(chk == FALSE)
	{
		qApp->beep();		
		return;
	}
		
	truss->update_mpset_beam(mpset,I,Q,SR1,SR2,NA_width);
	
	accept();

}
