/*

    This code is part of Truss Solver which is free software.
    See the file COPYING for more details.

    Copyright (C) 1997  T. W. Shield, shield@aem.umn.edu

*/

/**********************************************************************

	--- Dlgedit generated file ---

	File: MpsetEdit.cpp
	Last generated: Mon Sep 8 20:44:13 1997

 *********************************************************************/

#include <qapp.h>
#include <qstring.h>
#include "MpsetEdit.h"
#include "BeamProp.h"
#include "../global.h"
#include "../yesnoinfo.h"
#include "../icons/mpset_icon.xpm"
#include <stdio.h>

#define Inherited MpsetEditData

MpsetEdit::MpsetEdit
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	setCaption( "MPset Edit" );
	setFixedSize(width(),height());
	
	init();
/*
	set the window icon and text and window caption
*/


    QPixmap win_icon(mpset_icon);
    
    setIcon(win_icon);

    const char title[]="Edit MPSet";

    setCaption(title);
    setIconText(title);
	
}

void MpsetEdit::init()
{
	int n,i;
	char temp[10];
	
	if(truss->type() == FRAME)
	{
		beam_button->show();
	}
	else
	{
		beam_button->hide();
	}
	
	mpset_number_list->clear();
	
	n = truss->mpsets();
				
	if(n < 1)
		return;
		
	
	for(i=1;i<=n;i++)
	{
		sprintf(temp,"%i",i);
		mpset_number_list->insertItem(temp);
	}

	mpset_number_list->setCurrentItem(0);
	
	repaint();
}

MpsetEdit::~MpsetEdit()
{
}

void MpsetEdit::add_mpset()
{
	int n;
	char temp[10];
	
	truss->add_mpset_rod(1.0,1.0); // need to default rest of parms
	
	n = truss->mpsets();
	
	sprintf(temp,"%i",n);
	
	mpset_number_list->insertItem(temp);
	
	mpset_number_list->setCurrentItem(n-1); // causes set_mpset_number to be done
	
	if(truss->type() == FRAME)
		set_beam_properties(); // make beam properties pop up
	
	emit mpsets_changed();
}

void MpsetEdit::delete_mpset()
{
	int u,n;
	
	u = truss->mpset_used(mpset);
	
	if( u > 0)
	{
		InfoDialog info(this,"MP set still in use");
		info.exec();
		return;
	}
	
	truss->delete_mpset(mpset);
	
	n = mpset_number_list->count();
	
	if(mpset >= n)
		mpset = n-1;
	
	mpset_number_list->removeItem(n-1);
	
	sync_values();	
		
	emit mpsets_changed();

}
	
void MpsetEdit::set_area()
{
	float A;
	bool chk;
	
	QString qs(area_text->text());	
	
	A = qs.toFloat(&chk); // sets chk to TRUE if its a number
	
	if(chk == TRUE )
	{
		truss->update_mpset_rod(mpset,A,0.);
	
		sync_values();

		main_win->repaint(); // in case solution is discarded
	}
	else
		qApp->beep();
}
void MpsetEdit::set_modulus()
{
	float E;
	bool chk;
	
	QString qs(modulus_text->text());	
	
	E = qs.toFloat(&chk); // sets chk to TRUE if its a number
	
	if(chk == TRUE )
	{
	
		truss->update_mpset_rod(mpset,0.,E);
	
		sync_values();

		main_win->repaint(); // in case solution is discarded
	}
	else
		qApp->beep();
}
	
void MpsetEdit::set_mpset_number(int i)
{
	mpset = i+1;
	
	sync_values();


}

void MpsetEdit::sync_values()
{
	float E,A;
	char temp[20];
	
	E=truss->modulus(mpset);
	sprintf(temp,"%g",E);
	modulus_text->setText(temp);
	
	A=truss->area(mpset);
	sprintf(temp,"%g",A);
	area_text->setText(temp);
	
	

}

void MpsetEdit::set_beam_properties() // open the beam properties widget
{

	BeamProp bp(mpset,this);
	
	bp.exec();

}
