#include <qwidget.h>
#include <qpainter.h> 
#include <qpoint.h>
#include <qsize.h>
#include <qmenubar.h>
#include "fpoint.h"

// default file extensions
#define RESTRAINTS_EXT ".rts"
#define RESTRAINTS_TEXT "Restraint Files"
#define LOADS_EXT ".lds"
#define LOADS_TEXT "Load Files"
#define MODEL_EXT ".mdl"
#define MODEL_TEXT "Model Files"
#define RESULTS_EXT ".txt"
#define RESULTS_TEXT "Text Files"


// default node size on the screens
#define NODE_SIZE 20


class mywin : public QWidget 
{
	Q_OBJECT
public:
	mywin();
	void set_limits();

protected:
	void paintEvent(QPaintEvent *);
	void resizeEvent(QResizeEvent *);
	void mouseReleaseEvent(QMouseEvent *);

signals:
	void clicked(FPoint);
	void quit();
	void node_clicked(int);
	void elem_clicked(int);
	
public slots:
	void show_node(int);
	void show_position(FPoint);
	
// model menu slots
	void node_edit();
	void element_edit();
	void mpset_edit();
	void model_type();
	void bc_edit();
	void solve();
	void view_solution(); //opens text window with solution info 
		
// file menu slots
	void new_model();
	// open popup slots
		void input_model();
		void input_loads();
		void input_restraints();
	void example_model();
	// save popup slots
		void save_model();
		void save_loads();
		void save_restraints();
		void save_all();
	void print();	
	void exit();
	
// option slots
	void toggle_show_nodes();
	void set_snap();
	
// help menu slots
	void help();
	void about();	

private:
	float xmax,xmin,ymax,ymin;
	float scalex,scaley,transx,transy;
	QSize node_size;
	
	void setmatrix();
	
	void draw(QPaintDevice *,int prt_flag=0);
	
	int show_nodes; // =1 to show the nodes both screen and printer
	
	QPoint coords(float,float);
	QPoint coords(FPoint);
	FPoint icoords(QPoint);
	
	QMenuBar *menu;

	QPopupMenu *file_menu,*options_menu ;
	QPopupMenu *model_menu,*help_menu,*saves_menu,*opens_menu;
	
	int model_type_id; // menu entry id to change its text
	
	int save_model_id;// menu entry ids for saves menu
	int save_loads_id;
	int save_restraints_id;
	int save_all_id;
	
	int open_loads_id; // menu entry ids for opens menu
	int open_restraints_id;
	
	int solve_model_id; // model menu ids
	int view_solution_id;
	
	int show_nodes_id; // options menu id
	
	QString previous_dir;// keeps directory for subsequent opens
	
	float snap_spacing; // = 0 is off
	
	void init(); // reset scaling, etc

};

int qpdist(QPoint ,QPoint );
