/*

    This code is part of Truss Solver which is free software.
    See the file COPYING for more details.

    Copyright (C) 1997  T. W. Shield, shield@aem.umn.edu

*/

/**********************************************************************

	--- Dlgedit generated file ---

	File: NodeEdit.cpp
	Last generated: Wed Sep 3 21:35:21 1997

 *********************************************************************/

#include <qapp.h>
#include <qstring.h>
#include "NodeEdit.h"
#include <stdio.h>
#include "../global.h"
#include "../yesnoinfo.h"
#include "../icons/node_icon.xpm"


#define Inherited NodeEditData

NodeEdit::NodeEdit
(
	QWidget* parent,
	const char* name
)
	: 
	Inherited( parent, name )
{
	setCaption( "Node Edit" );
	
	setFixedSize(width(),height());
	
	init();
	
	connect(main_win,SIGNAL(clicked(FPoint)),SLOT(set_node_position(FPoint)));
	
	connect(main_win,SIGNAL(node_clicked(int)),SLOT(set_node(int)));
		
/*
	set the window icon and text and window caption
*/


    QPixmap win_icon(node_icon);
    
    setIcon(win_icon);

    const char title[]="Edit Nodes";

    setCaption(title);
    setIconText(title);
	
}

void NodeEdit::init()
{
	int n,i;
	char temp[20];
	
	n = truss->nodes();
	
	if(truss->type() == FRAME)
	{
		node_type_combo->show();
		node_type_label->show();
	}
	else
	{
		node_type_combo->hide();
		node_type_label->hide();
	}
	
	node_number_list->clear();
	
	if(n == 0)
		return;
			
	node_number_list->setAutoUpdate(FALSE);
	
	for(i=1;i<=n;i++)
	{
		sprintf(temp,"%i",i);
		node_number_list->insertItem(temp);
	}
	node_number_list->setAutoUpdate(TRUE);
	
	index = 1;
	
	node_number_list->setCurrentItem(index-1);
	
	sync_position();
	
	repaint();
}

NodeEdit::~NodeEdit()
{

}

void NodeEdit::update_node() // called from enter in text box
{
	FPoint p;
	QString qs;
	bool chk;
	float f;
	int i,ret;
	
	i = node_number_list->currentItem()+1;
	
	qs=node_x_text->text();
	
	f=qs.toFloat(&chk);
	
	if(chk == FALSE)
	{
		qApp->beep();		
		return;
	}
		
	p.setX(f);
	
	qs=node_y_text->text();
	
	f=qs.toFloat(&chk);
	
	if(chk == FALSE)
	{
		qApp->beep();		
		return;
	}
		
	p.setY(f);
	
	ret=truss->coincident_node_chk(i,p);
	
	if( ret == 0) // node position is ok
	{
	
		truss->set_node_pos(i,p);
		
		main_win->set_limits();
	
		main_win->repaint();
	}
	else
	{
		char temp[50];
		sprintf(temp,"Cannot move, too close to node %i",ret);
		InfoDialog info(this,temp);
		info.exec();
	}
}

void NodeEdit::sync_position(int i) // i is index in the list: 0 ... nodes-1
{
	
	index=i+1;
	
	sync_position();
}

void NodeEdit::sync_position()
{
	float x,y;
	char temp[20];

	x=truss->node_x(index);
	sprintf(temp,"%g",x);
	node_x_text->setText(temp);
	y=truss->node_y(index);
	sprintf(temp,"%g",y);
	node_y_text->setText(temp);
	
	if(truss->type() == FRAME )
	{
		node_type_combo->setCurrentItem(truss->node_type(index));
	}

}


void NodeEdit::delete_node()
{
	int n;
	
	if(truss->connects(index) != 0)
	{
		InfoDialog info(this,"Cannot Delete, Node is still connected");		
		info.exec();
		return;
	}
	
	if(truss->node_in_bc(index) != 0)
	{
		InfoDialog info(this,"Cannot Delete, Node has load/restraint");		
		info.exec();
		return;
	}
	
	
	truss->delete_node(index);
	n = truss->nodes();
	node_number_list->removeItem(n);
		
	if(index > n)
		index = n;
			
	sync_position();
		
	node_number_list->centerCurrentItem();
			
	emit nodes_changed();
			
	main_win->repaint();
		
}

void NodeEdit::add_node()
{
	int n,type;
	float x,y;
	char temp[20];
	
	x=0.;
	y=0.;
	truss->add_node(x,y);
	
	n = truss->nodes(); // includes the new node
		
	if(truss->type() == FRAME)
	{
		type=node_type_combo->currentItem();
		truss->set_node_type(n,type);
	}	
	
	sprintf(temp,"%i",n);
	node_number_list->insertItem(temp); // at end of list by default 
	node_number_list->setCurrentItem(n-1);
	node_number_list->centerCurrentItem();
	index = n;

	sync_position();
	
	main_win->repaint();
	
	emit nodes_changed();
	
}

void NodeEdit::set_node_position(FPoint p) // slot for main window mouse clicks
{
int ret;

	if(isVisible()) // only process clicks if Node Edit dialog is visible
	{
	
	// the coincident check is not really needed here as clicks
	// too close will return the node number not a screen position
	// but snap can change it to on top of another node, so we need this
	
		ret=truss->coincident_node_chk(index,p);
	
		if( ret == 0) // node position is ok
		{
	
			truss->set_node_pos(index,p);
	
			sync_position();
		
			main_win->set_limits();
			main_win->repaint();
			
		}
		else
		{
			char temp[50];
			sprintf(temp,"Cannot move, too close to node %i",ret);
			InfoDialog info(main_win,temp);
			info.exec();
		}
	}


}

void NodeEdit::set_node(int i) // slot for click on node number list
{
	if(isVisible())
	{

		node_number_list->setCurrentItem(i-1);
		node_number_list->centerCurrentItem();
		index = i;

		sync_position();
	}

}

void NodeEdit::set_node_type(int i)
{
/*
	 0 == pinned (default)
	 1 == rigid 
*/	 
	
	truss->set_node_type(index,i);
}
