/*

    This code is part of Truss Solver which is free software.
    See the file COPYING for more details.

    Copyright (C) 1997  T. W. Shield, shield@aem.umn.edu

*/

#include "vector.h"
#include <stdlib.h>
#include <math.h>


Vector::Vector(int size)
{

	init(size);
}

void Vector::init(int size)
{
	n = size;
	
	data=(float *)malloc(size*sizeof(float));
	
	if(data == 0)
	{
		cout << " malloc failed in vector\n";
		exit(1);
	}
	
	int i;
	
	for(i=0;i<n;i++)
	{
		*(data+i)=0.;
	}
	
}

Vector::Vector(Vector *v)
{
int i;
	init(v->size());
	
	for(i=1;i<=n;i++)
	{
		*(data+i-1)=v->val(i);
	}
}

Vector::Vector(Vector &v)
{
int i;
	init(v.size());
	
	for(i=1;i<=n;i++)
	{
		*(data+i-1)=v.val(i);
	}
}

Vector::~Vector()
{
	free(data);
}

void Vector::print(ostream *os)
{
int j;

	*os << "(";
	for(j=0;j<n;j++)
	{
		*os << *(data+j);
		if(j != n-1)
			*os << ",";
	}
	*os << ")\n";
}

ostream &operator<<(ostream &os, Vector *v)
{
	v->print(&os);
	return(os);
}

ostream &operator<<(ostream &os, Vector &v)
{
	v.print(&os);
	return(os);
}

float operator*(const Vector &l, const Vector &r)
{
int i;
float sum;

	sum = 0.;

#ifdef DEBUG
	if( l.size() != r.size())
	{
		cout << " size mismatch in vector *:"<<l.size()<<"\n";
		return(sum);
	}
#endif

	for(i=1;i<=r.size();i++)
	{
		sum = sum + l.val(i)*r.val(i);
	}
	
	return(sum);
}

void Vector::operator=(Vector src)
{
int i;

#ifdef DEBUG
	if( n != src.size())
	{
		cout << " size mismatch in Vector::operator=\n";
		return;
	}
#endif
	for(i=1;i<=n;i++)
	{
		val(i,src.val(i));
	}
}

int Vector::size() const
{
	return(n);
}

int Vector::size()
{
	return(n);
}

float Vector::val(int i) const 
{
/*

	range on i is 1 ... n
	
*/
#ifdef DEBUG

	if( i < 1 || i > n)
	{
		cout << " i range error in vector "<< i <<"\n";
		return(0.0);
	}
#endif
	
	return(*(data+i-1));
}

float Vector::val(int i) 
{
/*

	range on i is 1 ... n
	
*/
#ifdef DEBUG

	if( i < 1 || i > n)
	{
		cout << " i range error in vector "<< i <<"\n";
		return(0.0);
	}
#endif
	
	return(*(data+i-1));
}

void Vector::val(int i,float v)
{
#ifdef DEBUG
	
	if( i < 1 || i > n)
	{
		cout << " i range error in set vector\n";
		return;
	}
#endif
	
	*(data+i-1) = v;
}
