#include <iostream.h>

#ifndef VECTOR
#define VECTOR


class Vector
{

public:

	Vector(int); // call with desired starting size
	Vector( Vector *); // copy constructor
	Vector(Vector &); // copy constructor
	
	~Vector();

	float val(int) const;
	float val(int);
	void val(int,float);
	
	//float length(); // returns the norm of the vector
	
	int size()  const; // returns the size of the vector
	int size();

	void print(ostream *);
	
	void operator=(Vector );
	

private:
	int n;
	
	float *data;
	
	void init(int);
	
};

ostream &operator<<(ostream &os, Vector *v);
ostream &operator<<(ostream &os, Vector &v);

float operator*(const Vector&, const Vector&);

#endif // VECTOR
