/**********************************************************************

	--- Qt Architect generated file ---

	File: ViewText.cpp
	Last generated: Sun Dec 7 12:44:47 1997

 *********************************************************************/

#include "ViewText.h"
#include <qmenubar.h>
#include <qkeycode.h>
#include <qclipbrd.h>
#include "../global.h"

#define Inherited ViewTextData

ViewText::ViewText
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	init();
}

ViewText::ViewText
(
	QString text,
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	init();
	
	text_multiedit->clear();
	text_multiedit->setText(text);
}

void ViewText::init()
{
	setCaption( "View Results" );

	QPopupMenu *file_menu = new QPopupMenu();
	CHECK_PTR( file_menu);

       file_menu->insertItem("Save As...", this , SLOT(save()));
       file_menu->insertSeparator();
       file_menu->insertItem( "Close", this, SLOT(quit()), CTRL+Key_W );

	main_menu->insertItem( "File", file_menu );
	
	QPopupMenu *edit_menu = new QPopupMenu();
	CHECK_PTR( edit_menu);

	edit_menu->insertItem("Copy", this, SLOT(copy()), CTRL+Key_C);
	edit_menu->insertSeparator();
	edit_menu->insertItem("Select All",this,SLOT(select_all()), CTRL+Key_A);

	
	main_menu->insertItem( "Edit", edit_menu );


}


ViewText::~ViewText()
{
}

void ViewText::resizeEvent(QResizeEvent *resize)
{
	
	int mheight = main_menu->height();
	
	QSize offset(0,mheight);
	
	QSize text_size=resize->size()-offset;
	
	text_multiedit->resize(text_size);
	
	text_multiedit->move(0,mheight);


}

void ViewText::save()
{
	main_win->save_all();
}

void ViewText::copy()
{

	text_multiedit->copyText();

}

void ViewText::setText(QString text)
{
	text_multiedit->clear();
	text_multiedit->setText(text);
}


void ViewText::select_all()
{

	text_multiedit->selectAll();

}

void ViewText::quit()
{
	done(0);
}
