/*

    This code is part of Truss Solver which is free software.
    See the file COPYING for more details.

    Copyright (C) 1997  T. W. Shield, shield@aem.umn.edu

*/

#include "yesnoinfo.h"

#define BUTTON_WIDTH 100
#define BUTTON_HEIGHT 30
#define SPACE 10

YesNoDialog::YesNoDialog( QWidget *parent, const char *question )
      : QDialog( parent, "yesno", TRUE )
{
int w,h,qw,qh;

/* figure out the question size */

	QRect sz;
	QFontMetrics fm(font());
	sz=fm.boundingRect(question,strlen(question));
	
	qw=sz.width();  // question text sizes
	qh=sz.height();
	
	if(qw < (2*BUTTON_WIDTH+SPACE) )
		w = 2*BUTTON_WIDTH+3*SPACE;
	else
		w = qw+2*SPACE;
		
	h = 3*SPACE+BUTTON_HEIGHT+qh;		

/* set up the question label */

	QLabel *label;
	label = new QLabel(question,this);
	label->setAutoResize(TRUE);
	label->move(w/2-qw/2,SPACE);
	
/* set up buttons */

	QPushButton *yes, *no;
	yes = new QPushButton( "Yes", this );
	yes->setGeometry( SPACE,qh+2*SPACE, BUTTON_WIDTH, BUTTON_HEIGHT );
	connect( yes, SIGNAL(clicked()), SLOT(accept()) );
	no = new QPushButton( "No", this );
	no->setGeometry( w-BUTTON_WIDTH-SPACE,qh+2*SPACE, BUTTON_WIDTH, BUTTON_HEIGHT );
	connect( no, SIGNAL(clicked()), SLOT(reject()) );
	
/* for the whole dialog */

	setFixedSize(w,h);	
}

InfoDialog::InfoDialog( QWidget *parent, const char *info )
      : QDialog( parent, "info", TRUE )
{
int w,h,qw,qh;

/* figure out the info size */

	QRect sz;
	QFontMetrics fm(font());
	sz=fm.boundingRect(info,strlen(info));
	
	qw=sz.width();  // question text sizes
	qh=sz.height();
	
	if(qw < BUTTON_WIDTH )
		w = BUTTON_WIDTH+2*SPACE;
	else
		w = qw+2*SPACE;
		
	h = 3*SPACE+BUTTON_HEIGHT+qh;		

/* set up the info label */

	QLabel *label;
	label = new QLabel(info,this);
	label->setAutoResize(TRUE);
	label->move(w/2-qw/2,SPACE);
	
/* set up button */

	QPushButton *dismiss;
	dismiss = new QPushButton( "Dismiss", this );
	dismiss->setGeometry( w/2-BUTTON_WIDTH/2,qh+2*SPACE, BUTTON_WIDTH, BUTTON_HEIGHT );
	connect( dismiss, SIGNAL(clicked()), SLOT(accept()) );
	
/* for the whole dialog */

	setFixedSize(w,h);
	
		
}

#define INPUT_WIDTH 100

InputDialog::InputDialog( QWidget *parent, const char *question )
      : QDialog( parent, "input", TRUE )
{
int w,h,qw,qh;

/* figure out the question size */

	QRect sz;
	QFontMetrics fm(font());
	sz=fm.boundingRect(question,strlen(question));
	
	qw=sz.width();  // question text sizes
	qh=sz.height();
	
	if((qw+INPUT_WIDTH) < (2*BUTTON_WIDTH+SPACE) )
		w = 2*BUTTON_WIDTH+3*SPACE;
	else
		w = qw+2*SPACE+INPUT_WIDTH;
		
	h = 3*SPACE+BUTTON_HEIGHT+2*qh;		

/* set up the question label */

	QLabel *label;
	label = new QLabel(question,this);
	label->setAutoResize(TRUE);
	label->move(SPACE,SPACE);

/* set up the Input box */
	
	input = new QLineEdit(this);
	input->setGeometry(qw+2*SPACE, SPACE, INPUT_WIDTH,2*qh);
	connect(input,SIGNAL(returnPressed()),SLOT(accept()));
		
/* set up buttons */

	QPushButton *yes, *no;
	yes = new QPushButton( "Accept", this );
	yes->setGeometry( SPACE,2*qh+2*SPACE, BUTTON_WIDTH, BUTTON_HEIGHT );
	connect( yes, SIGNAL(clicked()), SLOT(accept()) );
	no = new QPushButton( "Cancel", this );
	no->setGeometry( w-BUTTON_WIDTH-SPACE,2*qh+2*SPACE, BUTTON_WIDTH, BUTTON_HEIGHT );
	connect( no, SIGNAL(clicked()), SLOT(reject()) );
	
/* for the whole dialog */

	setFixedSize(w,h);
		
}
 
const char *InputDialog::get_answer()
{
	return(input->text());
}
